//
//  DHDArtDMX.h
//  DHDMX
//
//  Created by Douglas Heriot on 8/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDArtNetPacket.h"

@class DHDArtDMXIdentity;


@interface DHDArtDMXPacket : DHDArtNetPacket

@property (readonly) NSData *DMX;
@property (readonly) DHDArtDMXIdentity *identity;
@property (readonly) NSUInteger DMXLength;
@property (readonly) uint8_t physical;
@property (readonly) uint8_t sequence;
@property (readonly) uint8_t version;
@property (readonly) uint16_t portAddress;

// New packet initialisers
- (id)initWithDMX:(NSData *)DMX identity:(DHDArtDMXIdentity *)identity;
- (id)initWithDMX:(NSData *)DMX identity:(DHDArtDMXIdentity *)identity sequence:(uint8_t)sequence;
- (id)initWithDMX:(NSData *)DMX identity:(DHDArtDMXIdentity *)identity sequence:(uint8_t)sequence physical:(uint8_t)physical;

- (id)initWithPacket:(DHDArtDMXPacket *)packet DMX:(NSData *)DMX sequence:(uint8_t)sequence;

@end
